/**
* \file: HIDPointerDevice.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Digital iPod Out - Wayland Adapter
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef DIPO_POINTERLISTENER_H
#define DIPO_POINTERLISTENER_H

#include "WaylandContext.h"
#include "HIDDigitizer.h"

namespace adit { namespace carplay
{

class IInputReceiver;

class DIPO_WL_HIDDEN_SYMBOL PointerListener : public WaylandContext::DeviceListener
{
public:
    static struct wl_pointer_listener Listener;

    PointerListener(IInputReceiver& inReceiver, HIDDigitizer& inDigitizer, int inWidth,
            int inHeight, bool inVerbose);
    virtual ~PointerListener();

private:
    float x;
    float y;
    float width;
    float height;
    uint8_t buttons;
    bool verbose;

    IInputReceiver& receiver;
    HIDDigitizer& hid;

    /* Wayland pointer listeners */
    static void handleEnter(void* inData, struct wl_pointer* inPointer, uint32_t inSerial,
            struct wl_surface* inSurface, wl_fixed_t inX, wl_fixed_t inY);
    static void handleLeave(void* inData, struct wl_pointer* inPointer, uint32_t inSerial,
            struct wl_surface* inSurface);
    static void handleMotion(void* inData, struct wl_pointer* inPointer, uint32_t inTime,
            wl_fixed_t inX, wl_fixed_t inY);
    static void handleButton(void* inData, struct wl_pointer* inPointer, uint32_t inSerial,
            uint32_t inTime, uint32_t inButton, uint32_t inState);
    static void handleAxis(void* inData, struct wl_pointer* inPointer, uint32_t inTime,
            uint32_t inAxis, wl_fixed_t inValue);
    static void handleFrame(void *inData, struct wl_pointer* inPointer);
    static void handleAxis_Source(void *inData, struct wl_pointer* inPointer, uint32_t inAxis_source);
    static void handleAxis_Stop(void *inData, struct wl_pointer* inPointer, uint32_t inTime, uint32_t inAxis);
    static void handleAxis_Discrete(void *inData, struct wl_pointer* inPointer, uint32_t inAxis, int32_t inDiscrete);
};

} } /* namespace adit { namespace carplay */

#endif /* DIPO_POINTERLISTENER_H */
